/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl;

import com.google.common.collect.ImmutableMap;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.ApiStatus;

public class ConfigHolderImpl
implements ConfigHolder {
    @ApiStatus.Internal
    public static final ConfigHolderImpl INSTANCE = new ConfigHolderImpl();
    private final Map<String, ConfigInstance> configs = new HashMap<String, ConfigInstance>();
    private final Map<Path, ConfigInstance> configsByPath = new HashMap<Path, ConfigInstance>();

    private ConfigHolderImpl() {
    }

    @Override
    public void register(String modId, ConfigInstance config) {
        if (this.isRegistered(modId)) {
            LibJf.LOGGER.warn("Overriding config class of " + modId + " to " + String.valueOf(config), new Object[0]);
        }
        LibJf.LOGGER.info("Registering config for " + modId, new Object[0]);
        this.configs.put(modId, config);
        config.getFilePath().ifPresent(path -> this.configsByPath.put((Path)path, config));
    }

    @Override
    public Map<String, ConfigInstance> getRegistered() {
        return ImmutableMap.copyOf(this.configs);
    }

    @Override
    public ConfigInstance get(String configClass) {
        return this.configs.get(configClass);
    }

    @Override
    public ConfigInstance get(Path configPath) {
        return this.configsByPath.get(configPath);
    }

    @Override
    public boolean isRegistered(String modId) {
        return this.configs.containsKey(modId);
    }

    @Override
    public boolean isRegistered(Path configPath) {
        return this.configsByPath.containsKey(configPath);
    }

    @Override
    public void migrateFiles(String modId) {
        Path cfg = FabricLoader.getInstance().getConfigDir();
        Path target = cfg.resolve(modId + ".json5");
        if (Files.exists(target, new LinkOption[0])) {
            return;
        }
        if (Files.exists(cfg.resolve(modId + ".json"), new LinkOption[0])) {
            try {
                Files.move(cfg.resolve(modId + ".json"), target, new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FabricLoader.getInstance().getModContainer(modId).ifPresent(mod -> {
            try {
                for (String id : mod.getMetadata().getProvides()) {
                    if (Files.exists(cfg.resolve(id + ".json"), new LinkOption[0])) {
                        Files.move(cfg.resolve(id + ".json"), target, new CopyOption[0]);
                        return;
                    }
                    if (!Files.exists(cfg.resolve(id + ".json5"), new LinkOption[0])) continue;
                    Files.move(cfg.resolve(id + ".json5"), target, new CopyOption[0]);
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

